import pandas as pd
import numpy as np
import pickle

# Load the dataset
atp_tennis = pd.read_csv("atp_tennis.csv")

# Convert the 'Date' column to datetime format
atp_tennis['Date'] = pd.to_datetime(atp_tennis['Date'])

# Find the last date in the dataset
last_date = atp_tennis['Date'].max()

# Filter the dataset to only include matches from the last five years
five_years_ago = last_date - pd.DateOffset(years=5)
recent_matches = atp_tennis[atp_tennis['Date'] >= five_years_ago]

# Find the top 10 ranked players
top_10_ranked_players = pd.concat([recent_matches[['Player_1', 'Rank_1']], recent_matches[['Player_2', 'Rank_2']].rename(columns={'Player_2': 'Player_1', 'Rank_2': 'Rank_1'})])
top_10_ranked_players = top_10_ranked_players.groupby('Player_1').min().sort_values('Rank_1').head(10)

# Convert the top 10 ranked players and their rankings to a Python list
top_10_ranked_players_list = top_10_ranked_players.reset_index().values.tolist()

print(top_10_ranked_players_list)
pickle.dump(top_10_ranked_players_list,open("./ref_result/top_10_ranked_players_list.pkl","wb"))